/*
 * Decompiled with CFR 0.152.
 */
import java.util.Date;

class Rise_Set {
    Date dat;
    int date;
    int month;
    int year;
    double latitude;
    double longitude;
    double Y0;
    double yPlus;
    double yMinus;
    double YE;
    double DX;
    int NZ;
    boolean RISE;
    boolean SETT;
    boolean ABOVE;
    double UTRISE;
    double UTSET;
    double hRise;
    double hSet;
    int locOffset;
    String riseStr;
    String setStr;
    double zero1;
    double zero2;
    double currentTime;
    int hours;
    int minutes;
    int seconds;
    double elev;

    public Rise_Set(Date date, double d, double d2, int n, double d3) {
        this.elev = d3;
        this.dat = date;
        this.date = this.dat.getDate();
        this.month = this.dat.getMonth();
        this.year = this.dat.getYear();
        this.hours = this.dat.getHours();
        this.minutes = this.dat.getMinutes();
        this.seconds = this.dat.getSeconds();
        this.currentTime = (double)this.hours + (double)this.minutes / 60.0 + (double)this.seconds / 3600.0;
        this.latitude = d;
        this.longitude = d2;
        this.RISE = false;
        this.SETT = false;
        int n2 = -n;
        while (n2 < -n + 24) {
            this.riseset(this.date, this.month + 1, this.year + 1900, n2);
            if (this.RISE && this.SETT) break;
            ++n2;
        }
        if (this.RISE || this.SETT) {
            if (this.RISE) {
                this.UTRISE += (double)n;
                if (this.UTRISE > 24.0) {
                    this.UTRISE -= 24.0;
                }
                if (this.UTRISE < 0.0) {
                    this.UTRISE += 24.0;
                }
            }
            if (this.SETT) {
                this.UTSET += (double)n;
                if (this.UTSET > 24.0) {
                    this.UTSET -= 24.0;
                }
                if (this.UTSET < 0.0) {
                    this.UTSET += 24.0;
                }
            }
            if (this.RISE) {
                this.hRise = this.UTRISE;
            }
            if (this.SETT) {
                this.hSet = this.UTSET;
            }
            if (this.RISE) {
                this.riseStr = this.makeTimeString("", this.hRise);
            } else if (this.ABOVE) {
                this.riseStr = "Sun visible all day";
                this.setStr = "Sun visible all day";
            } else {
                this.riseStr = "Sun unvisible all day";
                this.setStr = "Sun unvisible all day";
            }
            if (this.SETT) {
                this.setStr = this.makeTimeString("", this.hSet);
            } else if (this.ABOVE) {
                this.riseStr = "Sun visible all day";
                this.setStr = "Sun visible all day";
            } else {
                this.riseStr = "Sun unvisible all day";
                this.setStr = "Sun unvisible all day";
            }
        } else if (this.ABOVE) {
            this.riseStr = "Sun visible all day";
            this.setStr = "Sun visible all day";
        } else {
            this.riseStr = "Sun unvisible all day";
            this.setStr = "Sun unvisible all day";
        }
    }

    String rise_String() {
        return this.riseStr;
    }

    String set_String() {
        return this.setStr;
    }

    double h_rise() {
        return this.hRise;
    }

    double h_set() {
        return this.hSet;
    }

    public void riseset(int n, int n2, int n3, double d) {
        double d2 = Math.PI / 180;
        double d3 = Math.sin(Math.PI / 180 * this.elev);
        double d4 = this.Jul_Date(n, n2, n3, d);
        double d5 = this.sunDecRA(1, d4);
        double d6 = this.sunDecRA(2, d4);
        this.Y0 = this.sin_elev(d4, this.latitude, -this.longitude, d5, d6) - d3;
        double d7 = this.Jul_Date(n, n2, n3, d + 1.0);
        d5 = this.sunDecRA(1, d7);
        d6 = this.sunDecRA(2, d7);
        this.yPlus = this.sin_elev(d7, this.latitude, -this.longitude, d5, d6) - d3;
        double d8 = this.Jul_Date(n, n2, n3, d - 1.0);
        d5 = this.sunDecRA(1, d8);
        d6 = this.sunDecRA(2, d8);
        this.yMinus = this.sin_elev(d8, this.latitude, -this.longitude, d5, d6) - d3;
        this.ABOVE = this.yMinus > 0.0;
        this.QUAD();
        switch (this.NZ) {
            case 1: {
                if (this.yMinus < 0.0) {
                    this.UTRISE = d + this.zero1;
                    this.RISE = true;
                    break;
                }
                this.UTSET = d + this.zero1;
                this.SETT = true;
                break;
            }
            case 2: {
                if (this.YE < 0.0) {
                    this.UTRISE = d + this.zero2;
                    this.UTSET = d + this.zero1;
                } else {
                    this.UTRISE = d + this.zero1;
                    this.UTSET = d + this.zero2;
                }
                this.RISE = true;
                this.SETT = true;
                break;
            }
        }
    }

    public void QUAD() {
        this.NZ = 0;
        double d = 0.5 * (this.yMinus + this.yPlus) - this.Y0;
        double d2 = 0.5 * (this.yPlus - this.yMinus);
        double d3 = this.Y0;
        double d4 = -d2 / (2.0 * d);
        this.YE = (d * d4 + d2) * d4 + d3;
        double d5 = d2 * d2 - 4.0 * d * d3;
        if (d5 >= 0.0) {
            this.DX = 0.5 * Math.sqrt(d5) / Math.abs(d);
            this.zero1 = d4 - this.DX;
            this.zero2 = d4 + this.DX;
            if (Math.abs(this.zero1) <= 1.0) {
                ++this.NZ;
            }
            if (Math.abs(this.zero2) <= 1.0) {
                ++this.NZ;
            }
            if (this.zero1 < -1.0) {
                this.zero1 = this.zero2;
            }
        }
    }

    double sunDecRA(int n, double d) {
        double d2 = Math.PI * 2;
        double d3 = 0.917482;
        double d4 = 0.397778;
        double d5 = (d - 2451545.0) / 36525.0;
        double d6 = Math.PI * 2 * this.frac(0.993133 + 99.997361 * d5);
        double d7 = 6893.0 * Math.sin(d6) + 72.0 * Math.sin(2.0 * d6);
        double d8 = Math.PI * 2 * this.frac(0.7859453 + d6 / (Math.PI * 2) + (6191.2 * d5 + d7) / 1296000.0);
        double d9 = Math.sin(d8);
        double d10 = Math.cos(d8);
        double d11 = 0.917482 * d9;
        double d12 = 0.397778 * d9;
        double d13 = Math.sqrt(1.0 - d12 * d12);
        double d14 = 57.29577951308232 * Math.atan(d12 / d13);
        double d15 = 7.639437268410976 * Math.atan(d11 / (d10 + d13));
        if (d15 < 0.0) {
            d15 += 24.0;
        }
        if (n == 1) {
            return d14;
        }
        return d15;
    }

    double sin_elev(double d, double d2, double d3, double d4, double d5) {
        double d6 = Math.PI / 180;
        double d7 = 15.0 * (this.LM_Sidereal_Time(d, d3) - d5);
        if (d7 < 0.0) {
            d7 += 360.0;
        }
        return Math.cos(Math.PI / 180 * d2) * Math.cos(Math.PI / 180 * d4) * Math.cos(Math.PI / 180 * d7) + Math.sin(Math.PI / 180 * d2) * Math.sin(Math.PI / 180 * d4);
    }

    public String makeTimeString(String string, double d) {
        double d2;
        int n;
        String string2 = "?";
        if (d < 0.0) {
            d += 24.0;
        }
        if (d > 24.0) {
            d -= 24.0;
        }
        if ((n = (int)Math.round((d2 = d - (double)((int)d)) * 60.0)) == 60) {
            n = 0;
            d += 1.0;
        }
        string2 = n > 9 ? ":" : ":0";
        string2 = String.valueOf(String.valueOf((int)d) + string2 + n);
        if (d < 10.0) {
            string2 = "0" + string2;
        }
        return String.valueOf(string) + "  " + string2 + "  Hrs";
    }

    double Jul_Date(int n, int n2, int n3, double d) {
        double d2 = 10000.0 * (double)n3 + 100.0 * (double)n2 + (double)n;
        if (n2 <= 2) {
            n2 += 12;
            --n3;
        }
        double d3 = d2 <= 1.58210041E7 ? (double)(-2 + (n3 + 4716) / 4 - 1179) : (double)(n3 / 400 - n3 / 100 + n3 / 4);
        d2 = 365.0 * (double)n3 - 679004.0;
        double d4 = d2 + d3 + (double)((int)(30.6001 * (double)(n2 + 1))) + (double)n + d / 24.0;
        return d4 + 2400000.5;
    }

    double frac(double d) {
        if ((d -= (double)((int)d)) < 0.0) {
            d += 1.0;
        }
        return d;
    }

    double LM_Sidereal_Time(double d, double d2) {
        double d3 = this.GM_Sidereal_Time(d);
        return 24.0 * this.frac((d3 - d2 / 15.0) / 24.0);
    }

    double GM_Sidereal_Time(double d) {
        double d2 = d - 2400000.5;
        long l = (long)d2;
        double d3 = (d2 - (double)l) * 24.0;
        double d4 = ((double)l - 51544.5) / 36525.0;
        return 6.697374558 + 1.0027379093 * d3 + (8640184.812866 + (0.093104 - 6.2E-6 * d4) * d4) * d4 / 3600.0;
    }
}

